/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet;

import com.ibm.hwmca.fw.tasklet.impl.RawResponse;
import com.ibm.hwmca.fw.tasklet.impl.XFrameUtils;
import com.ibm.hwmca.fw.tasklet.impl.response.ErrorResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.NoActionResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.RedirectResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.ResponseData;
import com.ibm.hwmca.fw.tasklet.impl.response.TerminateResponseData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Map;

public class TaskletResponse
extends RawResponse {
    private static final String TRACE_MASKT = "XTSKOTQT";
    private static final String TRACE_MASKF = "XTSKOTQF";
    private static final String TRACE_MASKD = "XTSKOTQD";
    private boolean wasRedirected = false;
    protected ResponseData responseData = null;
    private Object context = null;
    private int taskletId = 0;

    public TaskletResponse() {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] <init>");
    }

    public final boolean isResponseSet() {
        return this.responseData != null;
    }

    public final int getTaskletId() {
        return this.taskletId;
    }

    public final void setTaskletId(int taskletId) {
        this.taskletId = taskletId;
    }

    public final ResponseData getResponseData() {
        return this.responseData;
    }

    public final void noAction() {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] noAction()");
        this.setResponseData(new NoActionResponseData());
    }

    public final void error(LocalizableText errorMsg, String errorDetails) {
        this.setResponseData(new ErrorResponseData(errorMsg, errorDetails));
    }

    public final void error(LocalizableText errorMsg, String errorDetails, Throwable cause) {
        this.setResponseData(new ErrorResponseData(errorMsg, errorDetails, cause));
    }

    public final void terminate() {
        this.terminate(false);
    }

    public final void terminate(boolean methodReturn) {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] terminate()");
        this.setResponseData(new TerminateResponseData(methodReturn));
    }

    public final void redirect(String redirectTarget) {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] redirect(" + redirectTarget + ")");
        this.redirect(redirectTarget, null, null, null);
    }

    public final void redirect(String redirectTarget, Object redirectData) {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] redirect(" + redirectTarget + "," + redirectData + ")");
        this.redirect(redirectTarget, redirectData, null, null);
    }

    public final void redirect(String redirectTarget, Object redirectData, Object redirectTaskletInitData, Map redirectInitRequestData) {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] redirect(" + redirectTarget + "," + redirectData + "," + redirectTaskletInitData + "," + redirectInitRequestData + ")");
        this.redirect(redirectTarget, redirectData, redirectTaskletInitData, redirectInitRequestData, false);
    }

    public final void redirect(String redirectTarget, Object redirectData, Object redirectTaskletInitData, Map redirectInitRequestData, boolean delayInitiatorDestroy) {
        Trace.trace(TRACE_MASKF, "[TaskletResponse] redirect(" + redirectTarget + "," + redirectData + "," + redirectTaskletInitData + "," + redirectInitRequestData + ")");
        this.setResponseData(new RedirectResponseData(redirectTarget, redirectData, redirectTaskletInitData, redirectInitRequestData, delayInitiatorDestroy));
    }

    public final Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return (Map)this.context;
    }

    public final boolean isContextSet() {
        return this.context != null;
    }

    public final void setWasRedirected(boolean value) {
        this.wasRedirected = value;
    }

    public final boolean wasRedirected() {
        return this.wasRedirected;
    }

    protected void setResponseData(ResponseData responseData) {
        if (this.responseData != null) {
            IllegalStateException ise = new IllegalStateException("TaskletResponse state already set");
            Trace.trace(TRACE_MASKF, "[TaskletResponse] state already set, traceback follows: \n" + XFrameUtils.getStackTrace(ise));
            throw ise;
        }
        this.responseData = responseData;
    }

    public String toString() {
        return "TaskletResponse[ResponseData=" + this.responseData + "]";
    }

    public void captureDebugInformation(StringBuffer sb) {
        sb.append("\tresponseData = ").append(this.responseData).append("\n");
        sb.append("\twasRedirected = ").append(this.wasRedirected).append("\n");
        sb.append("\ttaskletId = ").append(this.taskletId).append("\n");
        super.captureDebugInformation(sb);
    }

    public void debugToTrace() {
        Trace.trace("XTSK---F", "\tresponseData = " + this.responseData);
        Trace.trace("XTSK---F", "\twasRedirected = " + this.wasRedirected);
        Trace.trace("XTSK---F", "\ttaskletId = " + this.taskletId);
        super.debugToTrace();
    }
}

